/* sccsid[] = "@(#) $Id: //bas/46D/src/include/crfcconn.h#3 $ SAP" */   
//

// SAP RFC C++ Class library.
// Copyright (C) 1996 SAP America, Inc.
// All rights reserved.
                        
///////////////////////////////////////////////////////////////////////////////
//
//  File crfcconn.h
//
//  Declarations for the CRfcConnection class
///////////////////////////////////////////////////////////////////////////////

#ifndef CRFCCONN__H
#define CRFCCONN__H

#include "crfcstrn.h"
#include "crfcsimp.h"
#include "crfclist.h"
#include "crfcglob.h"
#include "crfcclnt.h"
#include "crfcstrc.h"
#include "crfcdata.h"

#if defined(SAPonRS6000)
#include "saprfc.h"
#if !defined(BOOL)
 #define BOOL int
#endif
#endif

#ifdef _WIN32
#ifndef STRICT
    #define STRICT
#endif
#include <windows.h>
#include <tchar.h>
                    
#define DEST             _T("Destination")
#define USER             _T("User")
#define CLIENT           _T("Client")
#define PASSWORD         _T("Password")
#define LANGUAGE         _T("Language")
#define HOSTNAME         _T("Host Name")
#define SYSTEMNUM        _T("System Number")
#define GATEWAYHOST      _T("Gateway Host")
#define GATEWAYSERV      _T("Gateway Service")
#define GROUP            _T("Group")
#define MSGSERVER        _T("Message Server")
#define SYSTEMNAME       _T("System Name")
#define USESAPGUI        _T("Interactive")
#define RFCMODE          _T("RFC Mode")
#define ENCRYPTION       _T("Password Encryption")
       

const  LINE_LEN = 80 ;
const  MAX_VALUE_NAME = 30;
const  MAX_VALUE_LEN  = 100; 

#define CRFCCONN_DEFAULT_CONSTRUCTOR \
            _T("CRfcConnection::CRfcConnection(void) called")
#define CRFCCONN_CONSTRUCTOR \
            _T("CRfcConnection::CRfcConnection(const RFC_USER_INFO...) called")
#define CRFCCONN_DESTRUCTOR \
            _T("CRfcConnection::~CRfcConnection(void) called")
#define CRFCCONN_ABORT \
            _T("CRfcConnection::Abort(char*) called")
#define CRFCCONN_ACCEPT \
            _T("CRfcConnection::Accept(char**) succeeded")
#define CRFCCONN_RFCACCEPT_FAIL \
            _T("CRfcConnection::Accept (char**): RfcAccept failure")
#define CRFCCONN_CLEAR \
            _T("CRfcConnection::Clear(void) called")
#define CRFCCONN_CLOSE \
            _T("CRfcConnection::Close(void) called")
#define CRFCCONN_CONNARGV \
            _T("CRfcConnection::ConnArgv(char**) called")
#define CRFCCONN_CONNECT \
            _T("CRfcConnection::Connect(void) called")
#define CRFCCONN_DOOPEN \
            _T("CRfcConnection::DoOpen (void *) called")
#define CRFCCONN_DOOPEN_FAILURE \
            _T("CRfcConnection::DoOpen (void *) failed!!")
#define CRFCCONN_SETUSERINFO \
            _T("CRfcConnection::SetUserInfo called")
#define CRFCCONN_SETCONNECTINFO \
            _T("CRfcConnection::DoOpen called")
#define CRFCCONN_GETSAFEHANDLE \
            _T("CRfcConnection::GetSafeHandle called")
#define CRFCCONN_OPEN \
            _T("CRfcConnection::Open called")
#define CRFCCONN_SAFEOPEN \
            _T("CRfcConnection::SafeOpen called")
#define CRFCCONN_SAFECONNECT \
            _T("CRfcConnection::SafeConnect called")
#define CRFCCONN_ACCEPTWIN32 \
            _T("CRfcConnection::Accept(char*) succeeded")
#define CRFCCONN_ACCEPTWIN32_FAILURE \
            _T("CRfcConnection::Accept(char*) failure!!")
#define CRFCCONN_WRITEREGISTRY \
            _T("CRfcConnection::WriteRegistry(HKEY, CSTR) called")
#define CRFCCONN_READREGISTRY \
            _T("CRfcConnection::ReadRegistry(HKEY, CSTR) called")
#define CRFCCONN_READVALUE \
            _T("CRfcConnection::ReadValue called")
#define CRFCCONN_SETVALUE \
            _T("CRfcConnection::SetValue called")
#define CRFCCONN_GETR3RELEASE_FAILURE \
            _T("CRfcConnection::GetR3SystemParameters failure!!")
#define CRFCCONN_GETR3SYSTEMINFO_FAILURE \
            _T("CRfcConnection::GetR3SystemInfo() failure!!")
#define CRFCCONN_WRITEREGISTRY_KEYERROR \
             _T("In CRfcConnection::WriteRegistry, error from functional call RegCreateKeyEx")
#define CRFCCONN_READREGISTRY_KEYERROR \
             _T("In CRfcConnection::ReadRegistry, error from functional call RegCreateKeyEx")

#define RFC_CONNECTION_HANDLE_NULL \
			 _T("RFC Connection Handle is NULL!!!")
#else

#define CRFCCONN_DEFAULT_CONSTRUCTOR \
            "CRfcConnection::CRfcConnection(void) called"
#define CRFCCONN_CONSTRUCTOR \
            "CRfcConnection::CRfcConnection(const RFC_USER_INFO...) called"
#define CRFCCONN_DESTRUCTOR \
            "CRfcConnection::~CRfcConnection(void) called"
#define CRFCCONN_ABORT \
            "CRfcConnection::Abort(char*) called"
#define CRFCCONN_ACCEPT \
            "CRfcConnection::Accept(char**) succeeded"
#define CRFCCONN_RFCACCEPT_FAIL \
            "CRfcConnection::Accept (char**): RfcAccept failure"
#define CRFCCONN_CLEAR \
            "CRfcConnection::Clear(void) called"
#define CRFCCONN_CLOSE \
            "CRfcConnection::Close(void) called"
#define CRFCCONN_CONNARGV \
            "CRfcConnection::ConnArgv(char**) called"
#define CRFCCONN_CONNECT \
            "CRfcConnection::Connect(void) called"
#define CRFCCONN_DOOPEN \
            "CRfcConnection::DoOpen (void *) called"
#define CRFCCONN_DOOPEN_FAILURE \
            "CRfcConnection::DoOpen (void *) failed!!"
#define CRFCCONN_SETUSERINFO \
            "CRfcConnection::SetUserInfo called"
#define CRFCCONN_SETCONNECTINFO \
            "CRfcConnection::DoOpen called"
#define CRFCCONN_GETSAFEHANDLE \
            "CRfcConnection::GetSafeHandle called"
#define CRFCCONN_OPEN \
            "CRfcConnection::Open called"
#define CRFCCONN_SAFEOPEN \
            "CRfcConnection::SafeOpen called"
#define CRFCCONN_SAFECONNECT \
            "CRfcConnection::SafeConnect called"
#define CRFCCONN_ACCEPTWIN32 \
            "CRfcConnection::Accept(char*) succeeded"
#define CRFCCONN_ACCEPTWIN32_FAILURE \
            "CRfcConnection::Accept(char*) failure!!"
#define CRFCCONN_WRITEREGISTRY \
            "CRfcConnection::WriteRegistry(HKEY, CSTR) called"
#define CRFCCONN_READREGISTRY \
            "CRfcConnection::ReadRegistry(HKEY, CSTR) called"
#define CRFCCONN_READVALUE \
            "CRfcConnection::ReadValue called"
#define CRFCCONN_SETVALUE \
            "CRfcConnection::SetValue called"
#define CRFCCONN_GETR3RELEASE_FAILURE \
            "CRfcConnection::GetR3SystemParameters failure!!"
#define CRFCCONN_GETR3SYSTEMINFO_FAILURE \
            "CRfcConnection::GetR3SystemInfo() failure!!"
#define CRFCCONN_WRITEREGISTRY_KEYERROR \
             "In CRfcConnection::WriteRegistry, error from functional call RegCreateKeyEx"
#define CRFCCONN_READREGISTRY_KEYERROR \
             "In CRfcConnection::ReadRegistry, error from functional call RegCreateKeyEx"

#define RFC_CONNECTION_HANDLE_NULL \
			 "RFC Connection Handle is NULL!!!"
#endif


//structure for R/3 user logon information
typedef struct RfcUserInfoStruct
{
    CRfcString   rstrClient;
    CRfcString   rstrUserName;
    CRfcString   rstrPassword;
    CRfcString   rstrLanguage;
	RfcUserInfoStruct()
	{
		rstrClient = "";
		rstrUserName = "";
		rstrPassword = "";
		rstrLanguage = "";
	};
	~RfcUserInfoStruct(){};
}   RFC_USER_INFO;


// enumerated type indicating the R/3 release of the R/3 system
//  with which the application is connecting
/*typedef enum
{
    RELUNKNOWN = 0x2120,
    REL30D,
    REL30E,
    REL30F,
    REL31G,
    REL31H,
    REL31I,
    REL40A,
    REL40B,
    REL40C
} R3_RELEASE;*/

#define RELEASEUNKNOWN   "RELEASEUNKNOWN"
#define RELEASE30D       "30D"
#define RELEASE30E       "30E"
#define RELEASE30F       "30F"
#define RELEASE31G       "31G"
#define RELEASE31H       "31H"
#define RELEASE31I       "31I"
#define RELEASE40A       "40A"
#define RELEASE40B       "40B"
#define RELEASE40C       "40C"
#define RELEASE45A       "45A"
#define RELEASE45B       "45B"
#define RELEASE46A       "46A"
#define RELEASE46B       "46B"
#define RELEASE99A       "99A"
#define RELEASE99B       "99B"

//structure for R/3 connection information 
typedef struct RfcConnectInfoStruct
{
    RFC_MODE     rfcMode;
    RFC_INT      nSAPGUI;      // Enable GUI display in RFC call

	char cRfcServerType;  
	// 2, 3, or E, RFC server is on R/2, R/3 system, an external program

	CRfcString rstrProgramID;  //  Path and name of the external RFC server program or Program ID of an registered RFC server program.
            // Used for external RFC server. If RFC server is already registered as a RFC destination on R/3 system using sm59 transaction on R/3.
	        // If RFC server will be started by the SAP gateway, it is the RFC server program name and full path on the computer that the RFC server will run.
    
//    R3_RELEASE   R3release;
    CRfcString  rstrR3release;

    // The user must set this flag in order to have the RFC function 
    //  RFC_SYSTEM_INFO called by the CRfcConnection class automatically
    //  after log-on.  Users who do not wish to access R3 system info
    //  can leave this flag FALSE to save resources.  At some point after
    //  log-on, users who did not have RFC_SYSTEM_INFO automatically
    //  called during log-on can still  obtain R3 system info by calling
    //  the public function GetR3SystemInfo().
    BOOL         bGetR3SystemInfo;    // Call RFC_SYSTEM_INFO during log on

    //Use only the following five entries when not 
    //using load balancing => use the Open() or SafeOpen() method
    CRfcString   rstrDestination;
    CRfcString   rstrHostName;         // Host name of target system;
    CRfcString   rstrGatewayHost;      // Gateway host name;
    CRfcString   rstrGatewayService;   // Gateway service;
    int          nSystemNo;            // System number ( 0-99 );    

    //Use only the following three entries when rfcMode is 
    //RFC_MODE_R3_VERSION3 and using load balancing
    //or the rfcMode is RFC_MODE_PARAMETER
    //=> use the Connect() or SafeConnect() method
    CRfcString   rstrSystemName;       //Name of the R/3 system 
    CRfcString   rstrMsgServer;        //Hostname of the message server 
    CRfcString   rstrGroupName;        //Name of a specific group of application
                                       //servers 

    RfcConnectInfoStruct()
    {
        // Initialize this flag to FALSE so that by default we are connected
        //  to R/3 systems of release < 4.0A, for backward compatibility
        //  purposes.
        //R3release = RELUNKNOWN;
		rfcMode = RFC_MODE_R3ONLY;
		nSAPGUI = 0;
		cRfcServerType = '3';  //  By default, RFC server is on R/3.
		rstrProgramID = "";
        rstrR3release = RELEASEUNKNOWN;

        // By default, we don't automatically call RFC_SYSTEM_INFO when loggin on
        //  to R/3
        bGetR3SystemInfo = FALSE;
		rstrDestination = "";
		rstrHostName = "";
		rstrGatewayHost = "";
		rstrGatewayService = "";
		nSystemNo = 0;
		rstrSystemName = "";
		rstrMsgServer = "";
		rstrGroupName = "";
    };
    ~RfcConnectInfoStruct(){};
}   RFC_CONNECT_INFO;


class CRfcClientFunc;


// CRfcConnection class declaration 
class CRfcConnection
{
public:
// constructors & destructor       
    CRfcConnection (void);
    // This constructor throws const char* for memory exceptions.
    CRfcConnection (const RFC_USER_INFO &userInfo, // user sign on information 
                    CSTR  destination = NULL     // R/3 system destination name,
                   );                            // which is defined in either
                                                 // SIDEINFO or SAPRFC.INI file
    virtual ~CRfcConnection (void);

// public operations
    void FromHandle(RFC_HANDLE RfcHandle, BOOL IsClient=TRUE) ;

	void SetCodePage(char * codepage);
	char * GetCodePage(void) const { return (char *) (CSTR) m_codePage; }

    // Command line parsing, does not support Windows 16
    // Throws const char* for memory exceptions.
    void  ConnArgv (char** argv);          

    // Accessor methods to data members

    const RFC_USER_INFO*    GetUserInfo    (void) const { return &m_UserInfo; }
    // Throws const char* for memory exceptions.
    void                    SetUserInfo    (const RFC_USER_INFO &userInfo );

    const RFC_CONNECT_INFO* GetConnectInfo (void) const { return &m_ConnectInfo; } 
    // Throws const char* for memory exceptions.
    void                    SetConnectInfo (const RFC_CONNECT_INFO 
                                                &connectInfo);

    // Make sure a connection to the target system is
    // still alive and user sigon information is validated
    // When the RFC handle is not "safe", returns RFC_HANDLE_NULL
    RFC_HANDLE              GetSafeHandle  (void); 
    // Returns the RFC connection handle without verification
    RFC_HANDLE              GetHandle      (void) const { return m_hRFC; } 

    int                     GetTraceLevel  (void) const { return m_nTraceLevel; }
    void                    SetTraceLevel  (int nTraceLevel);

    // Returns a flag indicating whether the R/3 system connected to is
    //  of release 4.0A or later, TRUE if so, FALSE if not.
    BOOL                    IsR3AtLeast40A(void) const { return m_ConnectInfo.rstrR3release >= RELEASE40A; }

    // Returns a string indicating the release version of the R/3
    //  system connected
    CSTR                    GetReleaseString() const { return m_ConnectInfo.rstrR3release; }
    
    // Calls GetRfcAttributes to get m_Attributes (RFC_ATTRIBUTES) structure filled.
    void                    GetR3Release();

    const RFC_ATTRIBUTES&   GetAttributes() const { return m_Attributes; }

    // Calls RFC_GET_SAP_SYSTEM_PARAMETERS to get R3 release information
    void                    GetR3SystemParameters(void);

    // Calls RFC_SYSTEM_INFO and fill m_SysInfo with returned information
    //  This function is automatically called during log-on by DoOpen()
    //  if the flag m_ConnectInfo.bGetR3SystemInfo is set.
    // Also, this function can be used 2 other ways:
    //  (1) when a CRfcConnection object is instantiated, and the RFC handle
    //      is obtained not by logging on but by calling FromHandle(...).  After
    //      calling FromHandle(...), this function can be called
    //  (2) CRfcServerFunc objects or objects of classes derived from
    //      CRfcServerFunc can obtain R3 system info by overriding the function
    //      Process() and calling this function from Process().  Note that
    //      to call this function from CRfcServerFunc, the CRfcConnection object
    //      used must be the original CRfcConnection object that called
    //      CRfcConnection::Accept() and received calls from R/3.  This
    //      CRfcConnection object can be obtained from calling
    //      CRfcServerFunc::GetServerApp() and CRfcServerApp::GetConnection().
    void GetR3SystemInfo(void);

    // Get system info value of field name given in argument
    //  These functions access m_SysInfo to retrieve system info stored there.
    //  Given the name of the field, the functions R3SystemInfo return
    //  CRfcData object containing the data, and the appropriate conversion
    //  operator should be called to extract the data from CRfcData (CSTR, RFC_INT,
    //  etc.)  The user can use the name of the field or index of a field to extract
    //  value.  Please see comments on class CRfcSystemInfo for desrciption of a field.
    const CRfcSimpleParam&  R3SystemInfo(CSTR InfoName);
    const CRfcSimpleParam&  R3SystemInfo(int nIndex);
    int						R3SystemInfoCount(void);

//  Save the command line argument for multithreading.  It is ugly.  But it is easy.
#if defined(CRFCwithTHREADS)  //  It is for internal use only.
	char ** GetCommandLineArgument(void) const {return m_argv;}
#endif

    // Connect/disconnect operations

    // Open an RFC connection.
    // Throws const char* for memory exceptions
    // throws RFC_ERROR_INFO_EX for RfcOpen failure.
    void    Open        (void);
    // Open an RFC connection and verify user logon info
    // Throws const char* for memory exceptions,
    // throws RFC_ERROR_INFO_EX for RfcOpen failure.
    //                       or when verification of safe handle failed.
    void    SafeOpen    (void);

    // Open an RFC connection with load balancing
    // Throws const char* for memory exceptions,
    // throws RFC_ERROR_INFO_EX for RfcOpen failure.
    void    Connect     (void);
    // Open an RFC connection with load balancing and user logon info 
    // verification.
    // Throws const char* for memory exceptions,
    // throws RFC_ERROR_INFO_EX for RfcOpen failure.
    //                       or when verification of safe handle failed.
    void    SafeConnect (void);
                                 
    void    Close       (void);         // Close this connection;
    void    Abort       (char* Message);// Abort this connection; 
    
    // Accept an incoming connection, console version
    // If a server application is started in non-register mode, 
    // in another words, it is started by remote shell or local 
    // gateway, the argument "argv" is passed automaticly. 
    //
    // A server application can be started in register mode
    // with Release 3.0C onwards this function can be used to register at
    // a SAP gateway and the server program will wait for next RFC request
    // by following  RfcDispatch or RfcListen or RfcGetName.
    //
    // Using this functionality a RFC server program can now already run
    // and work as a RFC daemon. A start of this server program locally by
    // a R/3 application server or SAPGUI or via remote shell by a SAP gateway
    // is no longer necessary.
    //
    // In this case the input parameter argv must have the following Syntax:
    //
    // argv[0]: -a<lt>Program ID<gt> e.g. own_host_name.program_name
    // argv[1]: -g<lt>host name of the SAP gateway<gt>
    // argv[2]: -s<lt>service of the SAP gateway<gt>, e.g. sapgw00
    //
    // The 3 parameters above must fit with the configuration in R/3.
    // (via SM59, Connection type T and Register Mode)
    // Throws RFC_ERROR_INFO_EX for accept failure.
    void    Accept      (char** argv);   
	
#ifdef _WIN32
    // Throws RFC_ERROR_INFO_EX for accept failure.
    void    Accept      (char* CommandLine); // Accept an incoming connection,
                                             //Windows application only
  
    // Access Windows registry for user logon and connection information 
    // The following value names are assoicated with a user
    // defined key:
    //      Destination     REG_SZ
    //      User            REG_SZ
    //      Client          REG_SZ
    //      Password        REG_SZ
    //      Language        REG_SZ
    //      Host Name       REG_SZ
    //      System Number   REG_DWORD
    //      Gateway Host    REG_SZ
    //      Gateway Service REG_SZ
    //      Group           REG_SZ
    //      Message Server  REG_SZ
    //      System Name     REG_SZ
    //      SAPGUI          REG_DWORD
    //      RFC Mode        REG_DWORD
    //      
    // Not all entries may be present under the key, depending on
    // connection modes.
    // Throws const char* for registery key creation failure.
    void    WriteRegistry (HKEY hKeyRoot, CSTR regPath);
    // Throws const char* for memory exceptions and register query failure.
    void    ReadRegistry  (HKEY hKeyRoot, CSTR regPath);  
#endif

    void    Clear (void); // clear connection and user logon information                      

    //Encryption and Decryption of password
	//user can overwrite with own encryption routines
    virtual void Encrypt (CRfcString& rfcString) ;
    virtual void Decrypt (CRfcString& rfcString) ;
//  Move to public so JRFC can use these methods
	//  These two functions convert between connect_param in RfcOpenEx
	//  and RFC_CONNECT_INFO and RFC_USER_INFO
	void ConnectParamFromConnectInfo(CRfcString & connect_param);     
    void ConnectInfoFromConnectParam(char * connect_param);   


private:  
  // Attributes
    RFC_HANDLE          m_hRFC    ;              // Connection handel;
    RFC_USER_INFO       m_UserInfo;              // User Logon info
    RFC_CONNECT_INFO    m_ConnectInfo;           // Connection info 
    int                 m_nTraceLevel;           // Trace level;
    
    BOOL                m_bSelfCreated;          // Indicates if the Rfc connection
                                                 // handle is actually created by this
                                                 // object.
    CRfcClientFunc      *m_pSystemInfoFunc;      // For calling RFC_SYSTEM_INFO


    CRfcList<CRfcSimpleParam>  m_SysInfo;        // For storing system info

    RFC_ATTRIBUTES      m_Attributes;            // the attributes structure
                                                 //  information in this structure
                                                 //  is provided by RFC
	CRfcString m_codePage;  //  Store codepage string 


//  Save the command line argument for multithreading.  It is ugly.  But it is easy.
#if defined(CRFCwithTHREADS)
	char ** m_argv;
#endif


//  Private operations
    // Disallow assignment and copying between CRfcConnection objects
    CRfcConnection(const CRfcConnection& sourceConn);
    CRfcConnection&   operator= (const CRfcConnection& sourceConn);

    // Throws const char* for memory exceptions, and RfcOpen failure.
   // void DoOpen (void* pConnectOption) ;  // No longer needed because we use RfcOpenEx now

    // Throws const char* for memory exceptions, and RfcOpenEx failure.
    void DoOpen (void) ;

    //pRFCPING is used mainly for verifing user sign on 
    //infomation 
    //static CRfcClientFunc* pRFCPING ;


#ifdef _WIN32
    BOOL ReadValue (HKEY  hKey, CSTR Name, BYTE* pValue) ;
    BOOL SetValue  (HKEY  hKey, LPCTSTR lpValueName, 
                    DWORD dwType, CONST BYTE*   pbData,
                    DWORD cbData) ;      

#endif
};


#endif        //CRFCCONN__H

